local super = require "Object"

Artifact = super:new()

function Artifact:new()
    self = super.new(self)
    
    self._input = nil
    self._dependencies = {}
    self._function = nil
    
    return self
end

function Artifact:trySetValue(input, errorFunction)
    warn('Artifact:trySetValue!')
end

function Artifact:setValue(input, dependencies, func)
    local oldInput, oldDependencies, oldFunction = self._input, self._dependencies, self._function
    self:addUndo(function() self:setValue(oldInput, oldDependencies, oldFunction) end)
    self._input = input
    self._dependencies = dependencies
    self._function = func
    self:invalidate(self)
end

function Artifact:getInput()
    return self._input
end

function Artifact:getDependencies()
    return self._dependencies
end

function Artifact:evaluate(dataset)
    if self._function then
        return self._function(dataset)
    end
    return Sequence:newWithArray({})
end

return Artifact
